/* 
 *  CallbackRequestToContactNumber.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.ContactNumberI;
import com.avaya.ccs.api.DestinationI;

public class CallbackRequestToContactNumber extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(CallbackRequestToContactNumber.class);
    private final DestinationI destination;
    private final ContactNumberI contactNumber;
    private final String callbackTime;
    private final String callbackExpiryTime;
    private final String callbackNote;

    public CallbackRequestToContactNumber(String interactionID, DestinationI destination, ContactNumberI contactNumber, String callbackTime, String callbackExpiryTime, String callbackNote) {
        super(LOG, interactionID);
        this.destination = destination;
        this.contactNumber = contactNumber;
        this.callbackTime = callbackTime;
        this.callbackExpiryTime = callbackExpiryTime;
        this.callbackNote = callbackNote;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().createCallback(destination, contactNumber, callbackTime, callbackExpiryTime, callbackNote);
        LOG.trace(methodName + "-");
        return null;
    }
}
